/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators;

import BryceImages.Rendering.ColorCalculator;
import BryceMath.DoubleMath.Vector;
import java.awt.Color;
import java.awt.Dimension;

public class cc2DLighting
extends ColorCalculator {
    public cc2DLighting(Dimension dim) {
        super(dim);
    }

    public cc2DLighting(int width, int height) {
        super(width, height);
    }

    @Override
    public Color getColor(double x, double y) {
        Color blue = new Color(200, 200, 255);
        Vector in = new Vector(x, y);
        Vector eye1 = new Vector(this.getWidth() / 3, this.getHeight() / 3);
        Vector eye2 = new Vector(this.getWidth() * 2 / 3, this.getHeight() / 3);
        Vector center = new Vector(this.getWidth() / 2, this.getHeight() / 2);
        Vector mouth = new Vector(this.getWidth() / 2, (double)this.getHeight() * 0.6);
        Color c1 = this.getPointColor(eye1, in, blue, 1.0);
        Color c2 = this.getPointColor(eye2, in, blue, 1.0);
        Color c3 = this.getArcColor(center, (double)this.getHeight() / 2.1, in, 0.001);
        Color cMouth = this.getPointColor(mouth, in, new Color(255, 100, 100), 0.2);
        Color green = new Color(10, 10, 10);
        Color innerMouth = this.getPointColor(mouth, in, new Color(200, 100, 100), 0.1);
        Color innerEye1 = this.getPointColor(eye1, in, green, 0.1);
        Color innerEye2 = this.getPointColor(eye2, in, green, 0.1);
        Color output = this.max_color(c1, c2, cMouth);
        return this.sub_color(output, innerMouth, innerEye1, innerEye2);
    }

    Color max_color(Color ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            r = Math.max(r, c.getRed());
            g = Math.max(g, c.getGreen());
            b = Math.max(b, c.getBlue());
            ++n2;
        }
        return new Color(r, g, b);
    }

    Color sub_color(Color initial, Color ... colors) {
        int r = initial.getRed();
        int g = initial.getBlue();
        int b = initial.getBlue();
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            r -= c.getRed();
            g -= c.getGreen();
            b -= c.getBlue();
            ++n2;
        }
        r = Math.max(0, r);
        g = Math.max(0, g);
        b = Math.max(0, b);
        return new Color(r, g, b);
    }

    Color getPointColor(Vector point, Vector in, Color c, double intensity) {
        Vector diff = in.sub(point);
        double mag = diff.mag();
        return this.Color_rgb(this.attenutate((double)c.getRed() * intensity, mag), this.attenutate((double)c.getGreen() * intensity, mag), this.attenutate((double)c.getBlue() * intensity, mag));
    }

    Color getArcColor(Vector center, double dist, Vector in, double intensity) {
        Vector onArc = in.sub(center).norm().mult(dist).add(center);
        double mag = onArc.sub(in).mag();
        return this.Color_rgb(this.attenutate(255.0 * intensity, mag), this.attenutate(100.0 * intensity, mag), this.attenutate(100.0 * intensity, mag));
    }

    Color Color_rgb(double r, double g, double b) {
        return new Color(this.bound(r, 0, 255), this.bound(g, 0, 255), this.bound(b, 0, 255));
    }

    int bound(double val, int lower, int upper) {
        return Math.min(Math.max(lower, (int)val), upper);
    }

    double attenutate(double val, double distance) {
        return val / ((distance /= 200.0) * distance);
    }
}

